#include <stddef.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <dirent.h>

#define	network_layer		1
#define	transport_layer		2
#define	application_layer	3

struct header_info{
  char		*fname;
  u_int32_t     offset; /* Bits - relative value: from the beginning of the current header */
  u_int16_t     size;   /* Bits */
  u_int8_t	swap;
};

struct header_hash_table{
  char			**hname;
  u_int16_t		layer;
  u_int16_t		nof;
  struct header_info	**hinf;
};

struct hdir_in{
  char 			*hfpath; /* Header file path */
  char			*hname;  /* Header name */
  u_int16_t		layer;	 /* Header Layer */
  u_int16_t		nof;     /* Number of fields */
  struct hdir_in	*next;
};

void count_headers(char *wdir, struct hdir_in **hdirs);

struct header_info **mount_field_table(char *path, u_int16_t nof);

struct header_hash_table **mount_header_table(struct hdir_in *hd, u_int16_t noh);
  
struct header_info *gimme_the_data(char *hname, char *fname, struct header_hash_table **hdrtable, u_int16_t noh, u_int16_t *layer);

u_int16_t count_noh(struct hdir_in *hd);

void show_hash_table(struct header_hash_table **hdrtable, u_int16_t noh);
