init 9 states;
load headers : "./headers";
load packets : "./packer/out_pack";
verbose off;
create state LOCK;
create state SEND_SYN;
create state GET_SYN_ACK;
create state FINISH_HANDSHAKE;
create state UNLOCK;
create state BYEBYE;
create state SND_GET;
create state ACK_PAGE;

state LOCK shell {
  command : "iptables -A INPUT -p tcp --source-port 80 -s 10.1.1.2/24 -j DROP"
  next state : SEND_SYN
};

state SEND_SYN  send_pack{
  pack_id : 1
  but:  {IP}>TCP.sport = {IP}>TCP.sport + 1 and
        {IP}>TCP.cksum = std_cksum(TCP)
  next state : GET_SYN_ACK
};

state GET_SYN_ACK recv_pack{
  bpf : "tcp"
  iface : eth0
  ( next state: FINISH_HANDSHAKE
    check:      {IP}>TCP.acknum == [1]TCP.seqnum + 1
  )
};

state FINISH_HANDSHAKE send_pack{
  pack_id: 1
  but:	{IP}>TCP.sport = {IP}>TCP.sport + 1 and
	{IP}>TCP.seqnum = {IP}>TCP.seqnum + 1 and
  	{IP}>TCP.flags = 0x10 and
	{IP}>TCP.acknum = [GET_SYN_ACK]{IP}>TCP.seqnum + 1 and
	{IP}>TCP.cksum = std_cksum(TCP)
  next state : SND_GET
};

state SND_GET send_pack{
  pack_id: 2
  but: 	{IP}>TCP.sport = {IP}>TCP.sport + 1 and
	{IP}>TCP.seqnum = [1]{IP}>TCP.seqnum + 1 and
	{IP}>TCP.acknum = [GET_SYN_ACK]{IP}>TCP.seqnum + 1 and
	{IP}>TCP.cksum = std_cksum(TCP)
  next state : UNLOCK
};

state UNLOCK shell {
  command : "iptables -F"
  next state : BYEBYE
};

state BYEBYE finish;

play!;
bye;
