%{
#include "../packman.h"
#include "y.tab.h"

int p_lineno = 1, state = 0;;
char *buffer;
char field[256];
char header[256];
char expr[2][1024];
u_int8_t buf_switch;
int addr[4];

%}

%%
[ \t]			;               /* ignore white space */
[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3} {
			  sscanf(yytext,"%d.%d.%d.%d",&(yylval.yyaddr[0]),\
			                              &(yylval.yyaddr[1]),\
						      &(yylval.yyaddr[2]),\
						      &(yylval.yyaddr[3]));
			  return ADDR; }
0x[0-9A-Fa-f]+		{sscanf(yytext,"%x",&yylval.yyint); return NUMBER; }
[0-9]+                  { yylval.yyint = strtoul(yytext,NULL,10); return NUMBER; }
bytes			return BYTES;
header			{ state = HEADER; return HEADER; }
headers			return HEADERS;
load			return LOAD;
out_pack_file		{ buf_switch = 0; return OUT_PACK_FILE;}
packet			return PACKET;
\{			return OPEN_BRACE;
\}			return CLOSE_BRACE;
\(			return OPEN_BRACK;
\)			return CLOSE_BRACK;
\'.\'			{ yylval.yyint = (u_int32_t)yytext[1];
			  return NUMBER;
			}
\".*\"			{ memset(expr[buf_switch],0,1024);
			  memcpy(expr[buf_switch],yytext,(strlen(yytext)-1)%1024);
			  yylval.yystr = expr[buf_switch] + 1;
			  return EXPR; }
[0-9a-z\_A-Z]+		{ switch(state){
			    case 0 :
			        buffer = field;
			      break;
			    case HEADER:
			        buffer = header;
				state = 0;
			      break;
			  }
			  memset(buffer,0,256);
			  memcpy(buffer,yytext,(strlen(yytext)+1)%256);
			  yylval.yystr = buffer;
			  buf_switch = 1;
			  return STR; }
\;			return 0;
[\n]			++p_lineno;
.			return yytext[0];
%%

yywrap(){
}
