#define MAX_LAYER 4
#define MTU 1500

struct pack{
  u_int16_t     id;
  u_int16_t     layer[MAX_LAYER];
  u_int16_t     psize;
  u_int8_t      data[MTU];
  struct pack   *next;
};

struct pack_vect{
  u_int16_t     id;
  u_int16_t     layer[MAX_LAYER];
  u_int16_t     psize;
  u_int8_t      data[MTU];
};

struct pack_info{
  u_int16_t     layer[MAX_LAYER];
  u_int16_t     size;
  u_int32_t     offset;
};

int put_in_a_file(char *fname, struct pack *l_pack, u_int32_t nop);

struct pack_vect *load_packs(char *fname, u_int32_t *nopa);

void show_buffs(u_char *buff, int size);

void show_packs(struct pack_vect *packs, int nop);

void show_packs2(struct pack_vect *packs, int nop);
