verbose on;
init 5 states;
load headers : "./headers";
load packets : "./packer/out_pack";
create state LOCK;
create state WAIT_ECHO_REQ;
create state SEND_ECHO_REPLY;
create state UNLOCK;
create state BYEBYE;

state LOCK shell {
  command : "iptables -A INPUT -p icmp -j DROP"
  next state : WAIT_ECHO_REQ
};

state UNLOCK shell {
  command : "iptables -F"
  next state : BYEBYE
};

state BYEBYE finish;

state WAIT_ECHO_REQ recv_pack{
  bpf : "icmp"
  iface : eth0
  ( next state: SEND_ECHO_REPLY
    check:      {IP}>ICMP_ECHO.type == 8
  )
};

state SEND_ECHO_REPLY send_pack{
  pack_id : 1
  but:	IP.saddr = [WAIT_ECHO_REQ]IP.daddr and
	IP.daddr = [WAIT_ECHO_REQ]IP.saddr and
	{IP}>ICMP_ECHO_REAL.id = [WAIT_ECHO_REQ]{IP}>ICMP_ECHO_REAL.id and
	{IP}>ICMP_ECHO_REAL.seqnum = [WAIT_ECHO_REQ]{IP}>ICMP_ECHO_REAL.seqnum and
	{IP}>ICMP_ECHO_REAL.data1 = [WAIT_ECHO_REQ]{IP}>ICMP_ECHO_REAL.data1 and
        {IP}>ICMP_ECHO_REAL.data2 = [WAIT_ECHO_REQ]{IP}>ICMP_ECHO_REAL.data2 and
        {IP}>ICMP_ECHO_REAL.data3 = [WAIT_ECHO_REQ]{IP}>ICMP_ECHO_REAL.data3 and
        {IP}>ICMP_ECHO_REAL.data4 = [WAIT_ECHO_REQ]{IP}>ICMP_ECHO_REAL.data4 and
        {IP}>ICMP_ECHO_REAL.data5 = [WAIT_ECHO_REQ]{IP}>ICMP_ECHO_REAL.data5 and
        {IP}>ICMP_ECHO_REAL.data6 = [WAIT_ECHO_REQ]{IP}>ICMP_ECHO_REAL.data6 and
        {IP}>ICMP_ECHO_REAL.data7 = [WAIT_ECHO_REQ]{IP}>ICMP_ECHO_REAL.data7 and
        {IP}>ICMP_ECHO_REAL.data8 = [WAIT_ECHO_REQ]{IP}>ICMP_ECHO_REAL.data8 and
        {IP}>ICMP_ECHO_REAL.data9 = [WAIT_ECHO_REQ]{IP}>ICMP_ECHO_REAL.data9 and
        {IP}>ICMP_ECHO_REAL.data10 = [WAIT_ECHO_REQ]{IP}>ICMP_ECHO_REAL.data10 and
        {IP}>ICMP_ECHO_REAL.data11 = [WAIT_ECHO_REQ]{IP}>ICMP_ECHO_REAL.data11 and
        {IP}>ICMP_ECHO_REAL.data12 = [WAIT_ECHO_REQ]{IP}>ICMP_ECHO_REAL.data12 and
        {IP}>ICMP_ECHO_REAL.data13 = [WAIT_ECHO_REQ]{IP}>ICMP_ECHO_REAL.data13 and
        {IP}>ICMP_ECHO_REAL.data14 = [WAIT_ECHO_REQ]{IP}>ICMP_ECHO_REAL.data14 and
        {IP}>ICMP_ECHO_REAL.data15 = [WAIT_ECHO_REQ]{IP}>ICMP_ECHO_REAL.data15 and
        {IP}>ICMP_ECHO_REAL.data16 = [WAIT_ECHO_REQ]{IP}>ICMP_ECHO_REAL.data16 and
        {IP}>ICMP_ECHO_REAL.data17 = [WAIT_ECHO_REQ]{IP}>ICMP_ECHO_REAL.data17 and
        {IP}>ICMP_ECHO_REAL.data18 = [WAIT_ECHO_REQ]{IP}>ICMP_ECHO_REAL.data18 and
        {IP}>ICMP_ECHO_REAL.data19 = [WAIT_ECHO_REQ]{IP}>ICMP_ECHO_REAL.data19 and
        {IP}>ICMP_ECHO_REAL.data20 = [WAIT_ECHO_REQ]{IP}>ICMP_ECHO_REAL.data20 and
        {IP}>ICMP_ECHO_REAL.data21 = [WAIT_ECHO_REQ]{IP}>ICMP_ECHO_REAL.data21 and
        {IP}>ICMP_ECHO_REAL.data22 = [WAIT_ECHO_REQ]{IP}>ICMP_ECHO_REAL.data22 and
        {IP}>ICMP_ECHO_REAL.data23 = [WAIT_ECHO_REQ]{IP}>ICMP_ECHO_REAL.data23 and
        {IP}>ICMP_ECHO_REAL.data24 = [WAIT_ECHO_REQ]{IP}>ICMP_ECHO_REAL.data24 and
        {IP}>ICMP_ECHO_REAL.data25 = [WAIT_ECHO_REQ]{IP}>ICMP_ECHO_REAL.data25 and
        {IP}>ICMP_ECHO_REAL.data26 = [WAIT_ECHO_REQ]{IP}>ICMP_ECHO_REAL.data26 and
        {IP}>ICMP_ECHO_REAL.data27 = [WAIT_ECHO_REQ]{IP}>ICMP_ECHO_REAL.data27 and
        {IP}>ICMP_ECHO_REAL.data28 = [WAIT_ECHO_REQ]{IP}>ICMP_ECHO_REAL.data28 and
	{IP}>ICMP_ECHO.cksum = 0 and
	{IP}>ICMP_ECHO.cksum = std_cksum(ICMP)
  next state : WAIT_ECHO_REQ
};

play!;
bye;
