init 6 states;
load headers : "./headers";
load packets : "./packer/out_pack";
create state LOCK;
create state SEND_SYN;
create state GET_SYN_ACK;
create state FINISH_HANDSHAKE;
create state UNLOCK;
create state BYEBYE;

state LOCK shell {
  command : "iptables -A INPUT -p tcp --source-port 80 -s 10.1.1.2/24 -j DROP"
  next state : SEND_SYN
};

state UNLOCK shell {
  command : "iptables -F"
  next state : BYEBYE
};

state BYEBYE finish;

state GET_SYN_ACK recv_pack{
  bpf : "tcp"
  iface : eth0
  ( next state: FINISH_HANDSHAKE
    check:      {IP}>TCP_CHG.acknum == [1]TCP_CHG.seqnum + 1
  )
};

state SEND_SYN  send_pack{
  pack_id : 1
  but: 	{IP}>TCP.sport = {IP}>TCP.sport and
	{IP}>TCP_CHG.cksum = std_cksum(TCP)
  next state : GET_SYN_ACK
};

state FINISH_HANDSHAKE send_pack{
  pack_id: 1
  but:	IP.id = IP.id + 1 and
	{IP}>TCP_CHG.seqnum = {IP}>TCP_CHG.seqnum + 1 and
  	{IP}>TCP_CHG.flags = 0x10 and
	{IP}>TCP_CHG.acknum = [GET_SYN_ACK]{IP}>TCP_CHG.seqnum + 1 and
	{IP}>TCP_CHG.cksum = std_cksum(TCP)
  next state : BYEBYE
};

show all;
play!;
bye;
