%{
#include "packman.h"
#include "y.tab.h"

int lineno = 1,state = 0;
static int action = 0;
char oper;
char *buffer;

char buffers[50][256];

u_int8_t buff_i = 0;
u_int8_t but_start = 0;
u_int8_t check_start = 0;

char expr[256];
%}

%%
[ \t]			;               /* ignore white space */
[0-9]+			{ yylval.yyint = atoi(yytext); return NUMBER; }
0x[0-9A-Fa-f]+		{sscanf(yytext,"%x",&yylval.yyint); return NUMBER; }
[0-9]+"us"		{ sscanf(yytext,"%uus",&yylval.yyint);
                	  return U_SEC; }
[0-9]+"ms"		{ sscanf(yytext,"%ums",&yylval.yyint);
                	  return M_SEC; }
\+|\-|\*|\/|\&|\||\^	{ yylval.yychar = yytext[0]; 
                          return OPER; }
"=="			return EQUAL;
action			return ACTION;
all			return ALL;
and			{ switch(action){
                            case SEND_PACKET_T: 
			      buff_i = but_start;
			      break;
			    case RECV_PACKET_T: 
			      buff_i = check_start;
			      break;
			  }
                          return PM_AND; }
bpf			return BPF;
but			{ but_start = buff_i+1;
                          return BUT;}
bye			return TERMINATE;
check			{ check_start = buff_i;
                          return CHECK;}
command			return COMMAND;
create		  	return CREATE;
finish			{ action = FINISH_T;
                          return FINISH_T;}
headers			return HEADERS;
iface			return IFACE;
init            	return INIT;
load			return LOAD;
next			{ state = NEXT;
                          return NEXT;}
off			return OFF;
on			return ON;
or			{ buff_i = check_start;
                          return PM_OR;}
pack_id			return PACK_ID;
packets			return PACKETS;
play!			return PLAY;
RID			return RID;
send_pack		{ action = SEND_PACKET_T;
                          return SEND_PACKET_T;}
shell			{ action = SHELL_T;
                          return SHELL_T;}
show			return SHOW;
state           	{ if((action == SEND_PACKET_T) && (state == NEXT) && but_start > 0)
                            buff_i = but_start;
                          return STATE;}
states			return STATES;
std_cksum		return STD_CHECKSUM;
store_pack		return STOR_PACK;
recv_pack		{ action = RECV_PACKET_T; 
                          return RECV_PACKET_T;}
resolve			return RESOLVE;
timeout			return TIMEOUT;
used			return USED;
verbose			return VERBOSE;
wait			return WAIT_T;
\{              	return OPEN_BRACE;
\}              	return CLOSE_BRACE;
\(              	return OPEN_BRACK;
\)              	return CLOSE_BRACK;
\'.\'			{ yylval.yychar = yytext[1];
			  return CHAR;
			}
\".*\"			{ memset(expr,0,256);
			  memcpy(expr,yytext,(strlen(yytext)-1)%256);
			  yylval.yystr = expr + 1;
			  return EXPR;
			}
[0-9a-z\_A-Z]+		{ buffer = buffers[buff_i];
			  buff_i = (buff_i+1)%50;
 			  memset(buffer,0,256);
			  memcpy(buffer,yytext,(strlen(yytext)+1)%256);
			  yylval.yystr = buffer;
			  return STR;
			}
[\n]			++lineno;
\;			{ buff_i = 0;
			  but_start = 0;
			  return 0;
			}
\>			return yytext[0];
\.			return yytext[0];
.			return yytext[0];
%%

yywrap(){
}
