#include <stdio.h>
#include "packit.h"

#define mask(n) ((1<<n)-1)

void show_buff(unsigned char *buff){
  int i;
  for(i=0;i<60;i+=2){
    printf("%c%.2x%.2x",(i%16==0)?('\n'):(' '),buff[i],buff[i+1]);
    fflush(stdout);
  }
}

void pack_it(unsigned char *pack, u_int32_t info, u_int16_t off, u_int16_t size){
  u_int16_t myword = off/32;
  u_int8_t  start_bit= off%32;
  u_int32_t *wrk = (u_int32_t *)pack;

  if(size < 32){
    wrk[myword] &= ~(mask(size)<<(start_bit));
    wrk[myword] |= (info&mask(size))<<start_bit;
  }else
     wrk[myword] = info;
}

