#include <sys/types.h>
#include <stdlib.h>
#include "colors.h"
#include "packman.h"

/*
 *  Sums the ASCII values of each caracter in a string
 */
u_int32_t string2int(char *name);

/* 
 * Returns the number of digits that the number 'N' contains
 */
int digits(int N);

/*
 * Returns 10^x
 */
u_int32_t pot10(u_int32_t x);

/*
 *  Square de number N and take m_digits digits of the middle of the number
 */
u_int32_t mid_square(u_int32_t N, u_int8_t m_digits);

/*
 *  It's a very simple hashing algorithm
 */
u_int32_t insert_hash(char *key, struct hash **hsh, u_int32_t max, u_int32_t pos);

/*
 *  Checks whether the State has already been created
 */

int16_t check_state(char *state, struct hash **hsh, u_int32_t max);

/*
 *  Links the hashing table to the state vector
 */
u_int8_t link_h2sv(struct hash **hsh, struct base **cell, u_int32_t hsh_pos);

/* 
 * Binds the action "SEND_PACK #pckt_id" to the state pointed by CELL[C_POS] 
 */
u_int8_t action_send(struct base **cell, u_int32_t c_pos, u_int32_t pckt_id, u_int32_t next, u_int16_t nobt, struct but_in *but_chainl);

/*
 * Binds the action "WAIT" to the state pointed by CELL[C_POS]
 */
u_int8_t action_wait(struct base **cell, u_int32_t c_pos, u_int32_t time, u_int32_t next);

/*
 * Binds the action "RECV_PACK" to the state pointed by CELL[C_POS]
 */
u_int8_t action_recv(struct base **cell, u_int32_t c_pos, char *bpf_expr, char *iface, struct brch_in *brch, u_int16_t nob, struct timeout to);

/*
 * Binds the action "SHELL" to the state pointed by CELL[C_POS]
 */
u_int8_t action_shell(struct base **cell, u_int32_t c_pos, struct shell sh);
	

/*
 *   Binds the action "FINISH" to the state pointed by CELL[C_POS]
 */
u_int8_t action_finish(struct base **cell, u_int32_t c_pos);

/*
 *  Shows the state table
 */
void show_state(struct base **cell, u_int32_t cell_pos);

void show_but(struct but *arg);

void show_all(struct base **cell, u_int32_t num);

/*
 *  Releases the struct but *
 */
void free_but(struct but **but);

/*
 *  Releases the struct phinf **
 */
void free_phinf(struct phinf **hinf, u_int16_t layer);

int get_argument(struct send *snd, struct base **cell, struct but *but, u_int32_t pckt_id, u_int8_t arg_id, u_int32_t *arg, u_int16_t waiting_packs, u_int8_t stage);

int carry_argument(struct send *snd, struct but *but, u_int32_t pckt_id, u_int32_t argument);

u_int32_t get_offset(u_char *pack, u_int32_t psize, struct field_off_bits field);

/*
 *  Convert arguments to IMMEDIATE type
 */
void to_immediate(struct but *but, u_int32_t arg_id, u_int32_t arg);

u_int32_t get_from_local_pack(u_int32_t packnumber, char *hname, char *fname);

int get_out();

int play();
